#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void getofmgmt_battleship(struct vg3_ofunc_ofmgmt *);

/* static structure for this object-managing */
static struct {
  int is_activated;            /* whether activated */
  unsigned int *seed;          /* pointer to seed for random numbers */
  int max_no;                  /* how many instances are to be created */
  int obj_running;             /* whether object-instance is active */
} mgmt_battleship;

static int f_activate(void *, struct vg3_ofunc *, va_list);
static void f_deactivate(void *, struct vg3_ofunc *);
static void f_run(void *, struct vg3_ofunc *);
static int f_data(void *, struct vg3_ofunc *, void *);


/* +++ get-function +++ */

/* fill out the passed structure for object-management-functions of this VgaGames3-object */
void
getofmgmt_battleship(struct vg3_ofunc_ofmgmt *ofm) {
  if (ofm == NULL) { return; }
  snprintf(ofm->oid, sizeof(ofm->oid), "%s", get_oid_name(OID_NAME_BATTLESHIP));
  ofm->f_activate = f_activate;
  ofm->f_deactivate = f_deactivate;
  ofm->f_run = f_run;
  ofm->f_data = f_data;
}


/* +++ object-management-functions +++ */

/* activate the managing of battleship-object
 * parameters in ap:
 * - int: how many instances are to be created
 */
static int
f_activate(void *vmain, struct vg3_ofunc *ofstruct, va_list ap)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }
  (void)gmain;

  memset(&mgmt_battleship, 0, sizeof(mgmt_battleship));

  mgmt_battleship.seed = VG3_ofunc_mgmt_get_seed(ofstruct, get_oid_name(OID_NAME_BATTLESHIP));

  /* get variadic parameters */
  mgmt_battleship.max_no = va_arg(ap, int);

  if (mgmt_battleship.max_no <= 0) { mgmt_battleship.max_no = 1; }

  mgmt_battleship.is_activated = 1;

  return 0;
}


/* deactivate the managing of battleship-object */
static void
f_deactivate(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { return; }
  if (!mgmt_battleship.is_activated) { return; }

  /* destroy all battleship-objects */
  VG3_ofunc_objlist_call_free(ofstruct, gmain, get_oid_name(OID_NAME_BATTLESHIP));

  /* clean up the static structure */
  memset(&mgmt_battleship, 0, sizeof(mgmt_battleship));
  mgmt_battleship.is_activated = 0;
}


/* execute managing of battleship-instances,
 * creating a new one, if not enough battleships are active
 */
static void
f_run(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { return; }
  if (!mgmt_battleship.is_activated) { return; }

  /* create new battleship-instance? */
  if (mgmt_battleship.max_no > 0 && !mgmt_battleship.obj_running) {
    int xm, ym;
    const struct vg3_ofunc_objfunc *ofc;

    ofc = VG3_ofunc_get_objfunc(ofstruct, get_oid_name(OID_NAME_BATTLESHIP));
    if (ofc == NULL) { mgmt_battleship.max_no = 0; return; }

    xm = gmain->winw + 400;
    ym = gmain->winh / 2;
    if (ofc->f_new(gmain, 0, xm, ym) == NULL) {
      fprintf(stderr, "%s\n", VG3_error());
      mgmt_battleship.max_no = 0;
      return;
    }
    mgmt_battleship.max_no--;
    mgmt_battleship.obj_running = 1;
  }
}


/* set variables */
static int
f_data(void *vmain, struct vg3_ofunc *ofstruct, void *vdata)
{
  struct g_main *gmain = vmain;
  struct fdata_number *fdnumber = (struct fdata_number *)vdata;

  if (gmain == NULL || ofstruct == NULL || fdnumber == NULL) { return 0; }
  if (!mgmt_battleship.is_activated) { return 0; }
  (void)gmain;

  if (fdnumber->flag == FDATA_HIT) {  /* clear obj_running */
    mgmt_battleship.obj_running = 0;
  } else if (fdnumber->flag == FDATA_DONE) {  /* whether all instances are through */
    if (mgmt_battleship.max_no > 0 || mgmt_battleship.obj_running) {
      fdnumber->number1 = 0;  /* no */
    } else {
      fdnumber->number1 = 1;  /* yes */
    }
  }

  return 1;
}
