#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void getofmgmt_bomber(struct vg3_ofunc_ofmgmt *);

/* static structure for this object-managing */
static struct {
  int is_activated;            /* whether activated */
  unsigned int *seed;          /* pointer to seed for random numbers */
  int obj_max, obj_hit;        /* how many instances were created and were destroyed */
  struct random_check *rdchk;  /* random-check */
  int freq;                    /* frequency of occurance of bomber in permille */
  int pause;                   /* actual pausing value: 0 = no, >0 = decrementing each loop, <0 = waiting for activation */
} mgmt_bomber;

static int f_activate(void *, struct vg3_ofunc *, va_list);
static void f_deactivate(void *, struct vg3_ofunc *);
static void f_run(void *, struct vg3_ofunc *);
static int f_data(void *, struct vg3_ofunc *, void *);


/* +++ get-function +++ */

/* fill out the passed structure for object-management-functions of this VgaGames3-object */
void
getofmgmt_bomber(struct vg3_ofunc_ofmgmt *ofm) {
  if (ofm == NULL) { return; }
  snprintf(ofm->oid, sizeof(ofm->oid), "%s", get_oid_name(OID_NAME_BOMBER));
  ofm->f_activate = f_activate;
  ofm->f_deactivate = f_deactivate;
  ofm->f_run = f_run;
  ofm->f_data = f_data;
}


/* +++ object-management-functions +++ */

/* activate the managing of bomber-object
 * parameters in ap:
 * - int: frequency in permille
 * - int: pausing-value
 */
static int
f_activate(void *vmain, struct vg3_ofunc *ofstruct, va_list ap)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }
  (void)gmain;

  memset(&mgmt_bomber, 0, sizeof(mgmt_bomber));

  mgmt_bomber.seed = VG3_ofunc_mgmt_get_seed(ofstruct, get_oid_name(OID_NAME_BOMBER));

  mgmt_bomber.rdchk = random_check_new(mgmt_bomber.seed, 1);
  if (mgmt_bomber.rdchk == NULL) { return -1; }

  /* get variadic parameters */
  mgmt_bomber.freq = va_arg(ap, int);
  mgmt_bomber.pause = va_arg(ap, int);

  if (mgmt_bomber.freq < 0) { mgmt_bomber.freq = 0; } else if (mgmt_bomber.freq > 1000) { mgmt_bomber.freq = 1000; }

  mgmt_bomber.is_activated = 1;

  return 0;
}


/* deactivate the managing of bomber-object */
static void
f_deactivate(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { return; }
  if (!mgmt_bomber.is_activated) { return; }

  /* destroy all bomber-objects */
  VG3_ofunc_objlist_call_free(ofstruct, gmain, get_oid_name(OID_NAME_BOMBER));

  /* clean up the static structure */
  random_check_free(mgmt_bomber.rdchk);
  memset(&mgmt_bomber, 0, sizeof(mgmt_bomber));
  mgmt_bomber.is_activated = 0;
}


/* execute managing of bomber-instances,
 * creating a new one, if not enough bombers are active
 */
static void
f_run(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { return; }
  if (!mgmt_bomber.is_activated) { return; }

  if (mgmt_bomber.pause != 0) {
    if (mgmt_bomber.pause > 0) { mgmt_bomber.pause--; }
    return;
  }

  /* create new bomber-instance? */
  if (random_check_exec(mgmt_bomber.rdchk, (mgmt_bomber.freq + 1) / 2)) {
    int xm, ym, xd, yd;
    const struct vg3_ofunc_objfunc *ofc;

    ofc = VG3_ofunc_get_objfunc(ofstruct, get_oid_name(OID_NAME_BOMBER));
    if (ofc == NULL) { mgmt_bomber.freq = 0; return; }

    xm = gmain->winw + 40;
    ym = (int)VG3_nw_random_getnext(20, gmain->winh - 20, mgmt_bomber.seed);
    xd = -(int)VG3_nw_random_getnext(8, 13, mgmt_bomber.seed);
    yd = 0;
    if (ym < gmain->winh / 3) {
      if (yd < 0) { yd = -yd; }
    } else if (ym > gmain->winh * 2 / 3) {
      if (yd > 0) { yd = -yd; }
    }
    if (ofc->f_new(gmain, 0, xm, ym, xd, yd) == NULL) {
      fprintf(stderr, "%s\n", VG3_error());
      mgmt_bomber.freq = 0;
      return;
    }
    mgmt_bomber.obj_max++;
    mgmt_bomber.pause = (int)VG3_nw_random_getnext(20, 50, mgmt_bomber.seed);
  }
}


/* set variables */
static int
f_data(void *vmain, struct vg3_ofunc *ofstruct, void *vdata)
{
  struct g_main *gmain = vmain;
  struct fdata_number *fdnumber = (struct fdata_number *)vdata;

  if (gmain == NULL || ofstruct == NULL || fdnumber == NULL) { return 0; }
  if (!mgmt_bomber.is_activated) { return 0; }
  (void)gmain;

  if (fdnumber->flag == FDATA_PAUSE) {  /* set pause */
    mgmt_bomber.pause = fdnumber->number1;
  } else if (fdnumber->flag == FDATA_HIT) {  /* set obj_hit */
    mgmt_bomber.obj_hit++;
  } else if (fdnumber->flag == FDATA_RATIO) {  /* return obj_max and obj_hit */
    fdnumber->number1 = mgmt_bomber.obj_max;
    fdnumber->number2 = mgmt_bomber.obj_hit;
  }

  return 1;
}
