#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void getofmgmt_mine(struct vg3_ofunc_ofmgmt *);

/* static structure for this object-managing */
static struct {
  int is_activated;            /* whether activated */
  unsigned int *seed;          /* pointer to seed for random numbers */
  struct random_check *rdchk;  /* random-check */
  int freq;                    /* frequency of occurance of mine in permille */
  int pause;                   /* pausing: 0 = no, >0 = decrementing each loop, <0 = waiting for activation */
} mgmt_mine;

static int f_activate(void *, struct vg3_ofunc *, va_list);
static void f_deactivate(void *, struct vg3_ofunc *);
static void f_run(void *, struct vg3_ofunc *);
static int f_data(void *, struct vg3_ofunc *, void *);


/* +++ get-function +++ */

/* fill out the passed structure for object-management-functions of this VgaGames3-object */
void
getofmgmt_mine(struct vg3_ofunc_ofmgmt *ofm) {
  if (ofm == NULL) { return; }
  snprintf(ofm->oid, sizeof(ofm->oid), "%s", get_oid_name(OID_NAME_MINE));
  ofm->f_activate = f_activate;
  ofm->f_deactivate = f_deactivate;
  ofm->f_run = f_run;
  ofm->f_data = f_data;
}


/* +++ object-management-functions +++ */

/* activate the managing of mine-object
 * parameters in ap:
 * - int: frequency in permille
 * - int: pausing-value
 */
static int
f_activate(void *vmain, struct vg3_ofunc *ofstruct, va_list ap)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }
  (void)gmain;

  memset(&mgmt_mine, 0, sizeof(mgmt_mine));

  mgmt_mine.seed = VG3_ofunc_mgmt_get_seed(ofstruct, get_oid_name(OID_NAME_MINE));

  mgmt_mine.rdchk = random_check_new(mgmt_mine.seed, 1);
  if (mgmt_mine.rdchk == NULL) { return -1; }

  /* get variadic parameters */
  mgmt_mine.freq = va_arg(ap, int);
  mgmt_mine.pause = va_arg(ap, int);

  if (mgmt_mine.freq < 0) { mgmt_mine.freq = 0; } else if (mgmt_mine.freq > 1000) { mgmt_mine.freq = 1000; }

  mgmt_mine.is_activated = 1;

  return 0;
}


/* deactivate the managing of mine-object */
static void
f_deactivate(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { return; }
  if (!mgmt_mine.is_activated) { return; }

  /* destroy all mine-objects */
  VG3_ofunc_objlist_call_free(ofstruct, gmain, get_oid_name(OID_NAME_MINE));

  /* clean up the static structure */
  random_check_free(mgmt_mine.rdchk);
  memset(&mgmt_mine, 0, sizeof(mgmt_mine));
  mgmt_mine.is_activated = 0;
}


/* execute managing of mine-instances,
 * creating a new one, if not enough mines are active
 */
static void
f_run(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (gmain == NULL || ofstruct == NULL) { return; }
  if (!mgmt_mine.is_activated) { return; }

  if (mgmt_mine.pause != 0) {
    if (mgmt_mine.pause > 0) { mgmt_mine.pause--; }
    return;
  }

  /* create new mine-instance? */
  if (random_check_exec(mgmt_mine.rdchk, (mgmt_mine.freq + 1) / 2)) {
    int xm, ym, xd, yd, rot;
    const struct vg3_ofunc_objfunc *ofc = VG3_ofunc_get_objfunc(ofstruct, get_oid_name(OID_NAME_MINE));
    if (ofc == NULL) { mgmt_mine.freq = 0; return; }

    xm = gmain->winw + 50;
    ym = (int)VG3_nw_random_getnext(20, gmain->winh - 20, mgmt_mine.seed);
    xd = -(int)VG3_nw_random_getnext(1, 10, mgmt_mine.seed);
    yd = (int)VG3_nw_random_getnext(0, 10, mgmt_mine.seed) - 5;
    rot = (int)VG3_nw_random_getnext(1, 2, mgmt_mine.seed);
    if (rot == 2) { rot = -1; }
    if (ym < gmain->winh / 3) {
      if (yd < 0) { yd = -yd; }
    } else if (ym > gmain->winh * 2 / 3) {
      if (yd > 0) { yd = -yd; }
    }
    if (ofc->f_new(gmain, 0, xm, ym, xd, yd, rot) == NULL) {
      fprintf(stderr, "%s\n", VG3_error());
      mgmt_mine.freq = 0;
      return;
    }
    mgmt_mine.pause = (int)VG3_nw_random_getnext(10, 20, mgmt_mine.seed);
  }
}


/* set variables */
static int
f_data(void *vmain, struct vg3_ofunc *ofstruct, void *vdata)
{
  struct g_main *gmain = vmain;
  struct fdata_number *fdnumber = (struct fdata_number *)vdata;

  if (gmain == NULL || ofstruct == NULL || fdnumber == NULL) { return 0; }
  if (!mgmt_mine.is_activated) { return 0; }
  (void)gmain;

  if (fdnumber->flag == FDATA_PAUSE) {  /* set pause */
    mgmt_mine.pause = fdnumber->number1;
  }

  return 1;
}
