#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-asteroid.h"

void getoofc_asteroid_asteroid(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_asteroid_asteroid(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_ASTEROID));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ASTEROID));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_asteroid *gobj1, *gobj2;
  int vch;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* assign */
  gobj1 = (struct g_obj_asteroid *)objp1->ostruct;
  gobj2 = (struct g_obj_asteroid *)objp2->ostruct;

  if (collret->side & (VGAG3_COLLSIDE_RIGHT | VGAG3_COLLSIDE_LEFT)) {
    vch = gobj1->xdelta;
    gobj1->xdelta = gobj2->xdelta;
    gobj2->xdelta = vch;
  }

  if (collret->side & (VGAG3_COLLSIDE_TOP | VGAG3_COLLSIDE_BOTTOM)) {
    vch = gobj1->ydelta;
    gobj1->ydelta = gobj2->ydelta;
    gobj2->ydelta = vch;
  }

  return VGAG3_COLL_RETURN_CONTINUE;
}
