#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-battleship.h"
#include "obj-playershot.h"

void getoofc_battleship_playershot(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_battleship_playershot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_BATTLESHIP));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_PLAYERSHOT));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_battleship *gobj_battleship;
  struct g_obj_playershot *gobj_playershot;
  int retw;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* assign battleship and playershot */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_BATTLESHIP)) == 0) {
    gobj_battleship = (struct g_obj_battleship *)objp1->ostruct;
    gobj_playershot = (struct g_obj_playershot *)objp2->ostruct;
  } else {
    gobj_battleship = (struct g_obj_battleship *)objp2->ostruct;
    gobj_playershot = (struct g_obj_playershot *)objp1->ostruct;
  }

  /* not before battleship has reached position */
  if (gobj_battleship->ydelta == 0) { return VGAG3_COLL_RETURN_NOOP; }

  /* battleship reduces health and playershot reduces strength */
  if (gobj_battleship->health > gobj_playershot->strength) {
    gobj_battleship->health -= gobj_playershot->strength;
    gobj_playershot->strength = 0;
  } else {
    gobj_playershot->strength -= gobj_battleship->health;
    gobj_battleship->health = 0;
  }

  /* set return value according to health/strength of objp1 */
  retw = VGAG3_COLL_RETURN_NOOP;
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_BATTLESHIP)) == 0) {
    if (gobj_battleship->health == 0) { retw = VGAG3_COLL_RETURN_HIT; }
  } else {
    if (gobj_playershot->strength == 0) { retw = VGAG3_COLL_RETURN_HIT; }
  }

  /* draw hit-sprite */
  if (gobj_battleship->health > 0) {
    if (gobj_playershot->hitkz > 0) { VG3_audio_play(gmain->wstruct, gobj_playershot->hitkz, 0, 0); }
    gobj_battleship->hit_y = gobj_playershot->rect.y + gobj_playershot->rect.h / 2 - gobj_battleship->rect.y;
    if (gobj_battleship->hit_y <= 0) { gobj_battleship->hit_y = 1; }
  }

  return retw;
}
