#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-factory.h"
#include "obj-fightershot.h"

void getoofc_factory_fightershot(struct vg3_ofunc_objobjfunc *);

static void f_quit(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getoofc_factory_fightershot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_FACTORY));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_FIGHTERSHOT));

  oofc->f_quit = f_quit;
}


/* +++ object-to-object-functions +++ */

/* quit-function */
static void
f_quit(void *vmain, struct vg3_ofunc_object *objp, struct vg3_ofunc_object *oparent)
{
  struct g_main *gmain = vmain;
  struct g_obj_factory *gobj_factory;

  if (gmain == NULL || objp == NULL || oparent == NULL) { return; }

  /* valid only when objp is fightershot and oparent is factory */
  if (strcmp(objp->oid, get_oid_name(OID_NAME_FIGHTERSHOT)) != 0) { return; }
  if (strcmp(oparent->oid, get_oid_name(OID_NAME_FACTORY)) != 0) { return; }

  /* clear factory's running shot */
  gobj_factory = (struct g_obj_factory *)oparent->ostruct;
  gobj_factory->shot.running--;
}
