#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-fighter.h"
#include "obj-asteroid.h"

void getoofc_fighter_asteroid(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_fighter_asteroid(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_FIGHTER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ASTEROID));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_fighter *gobj_fighter;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private struct of OID_NAME_FIGHTER and OID_NAME_ASTEROID */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_FIGHTER)) == 0) {
    gobj_fighter = (struct g_obj_fighter *)objp1->ostruct;
  } else {
    gobj_fighter = (struct g_obj_fighter *)objp2->ostruct;
  }

  /* fighter explodes */
  gobj_fighter->health = 0;

  return VGAG3_COLL_RETURN_HIT;
}
