#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-mothership.h"
#include "obj-mothershot.h"

void getoofc_mothership_mothershot(struct vg3_ofunc_objobjfunc *);

static void f_quit(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getoofc_mothership_mothershot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_MOTHERSHIP));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_MOTHERSHOT));

  oofc->f_quit = f_quit;
}


/* +++ object-to-object-functions +++ */

/* quit-function */
static void
f_quit(void *vmain, struct vg3_ofunc_object *objp, struct vg3_ofunc_object *oparent)
{
  struct g_main *gmain = vmain;
  struct g_obj_mothership *gobj_mothership;

  if (gmain == NULL || objp == NULL || oparent == NULL) { return; }

  /* valid only when objp is mothershot and oparent is mothership */
  if (strcmp(objp->oid, get_oid_name(OID_NAME_MOTHERSHOT)) != 0) { return; }
  if (strcmp(oparent->oid, get_oid_name(OID_NAME_MOTHERSHIP)) != 0) { return; }

  /* clear mothership's running shot */
  gobj_mothership = (struct g_obj_mothership *)oparent->ostruct;
  gobj_mothership->shot.running--;
}
