#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-player.h"
#include "obj-fightershot.h"

void getoofc_player_fightershot(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_player_fightershot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_PLAYER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_FIGHTERSHOT));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_player *gobj_player;
  struct g_obj_fightershot *gobj_fightershot;
  int retw;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* assign player and fightershot */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_PLAYER)) == 0) {
    gobj_player = (struct g_obj_player *)objp1->ostruct;
    gobj_fightershot = (struct g_obj_fightershot *)objp2->ostruct;
  } else {
    gobj_player = (struct g_obj_player *)objp2->ostruct;
    gobj_fightershot = (struct g_obj_fightershot *)objp1->ostruct;
  }

  /* player reduces health and fightershot reduces strength */
  if (gobj_player->health > gobj_fightershot->strength) {
    gobj_player->health -= gobj_fightershot->strength;
    gobj_fightershot->strength = 0;
  } else {
    gobj_fightershot->strength -= gobj_player->health;
    gobj_player->health = 0;
  }

  /* set return value according to health/strength of objp1 */
  retw = VGAG3_COLL_RETURN_NOOP;
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_PLAYER)) == 0) {
    if (gobj_player->health == 0) { retw = VGAG3_COLL_RETURN_HIT; }
  } else {
    if (gobj_fightershot->strength == 0) { retw = VGAG3_COLL_RETURN_HIT; }
  }

  /* draw hit-sprite */
  if (gobj_player->health > 0) {
    if (gobj_player->hitkz > 0) { VG3_audio_play(gmain->wstruct, gobj_player->hitkz, 0, 0); }
    gobj_player->draw.hit = 1;
  }

  return retw;
}
