#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-player.h"
#include "obj-mine.h"

void getoofc_player_mine(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_player_mine(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_PLAYER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_MINE));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_player *gobj_player;
  struct g_obj_mine *gobj_mine;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private struct of OID_NAME_PLAYER and OID_NAME_MINE */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_PLAYER)) == 0) {
    gobj_player = (struct g_obj_player *)objp1->ostruct;
    gobj_mine = (struct g_obj_mine *)objp2->ostruct;
  } else {
    gobj_player = (struct g_obj_player *)objp2->ostruct;
    gobj_mine = (struct g_obj_mine *)objp1->ostruct;
  }

  if (collret->tag == 1) {  /* long-distance-quadtree */
    int distmom, distmax, iw, ih, rotpz;
    /* get distance for x- and y-direction */
    iw = (gobj_mine->crect_long.x + gobj_mine->crect_long.w / 2) - (gobj_player->crect.x + gobj_player->crect.w / 2);
    if (iw < 0) { iw = -iw; }
    ih = (gobj_mine->crect_long.y + gobj_mine->crect_long.h / 2) - (gobj_player->crect.y + gobj_player->crect.h / 2);
    if (ih < 0) { ih = -ih; }
    /* use shortest distance */
    if (ih < iw) {  /* y-direction */
      distmom = iw;
      distmax = gobj_mine->crect_long.w / 2 + gobj_player->crect.w / 2;
    } else {  /* x-direction */
      distmom = ih;
      distmax = gobj_mine->crect_long.h / 2 + gobj_player->crect.h / 2;
    }
    if (distmom < distmax * 5 / 12) {  /* both explode */
      gobj_player->health = 0;
      gobj_mine->health = 0;
      return VGAG3_COLL_RETURN_HIT;
    }
    if (distmom < distmax * 5 / 6) {  /* ping-sound */
      VG3_audio_play(gmain->wstruct, gobj_mine->pingsnd, 0, 0);
    }
    /* calculate rotation */
    rotpz = distmom * 100 / distmax;
    gobj_mine->rot1 = gobj_mine->rot0 + gobj_mine->rot0 * (100 - rotpz) / 5;
    return VGAG3_COLL_RETURN_CONTINUE;

  } else {
    /* both explode */
    gobj_player->health = 0;
    gobj_mine->health = 0;
  }

  return VGAG3_COLL_RETURN_HIT;
}
