#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-player.h"
#include "obj-playershot.h"

void getoofc_player_playershot(struct vg3_ofunc_objobjfunc *);

static void f_quit(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getoofc_player_playershot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_PLAYER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_PLAYERSHOT));

  oofc->f_quit = f_quit;
}


/* +++ object-to-object-functions +++ */

/* quit-function */
static void
f_quit(void *vmain, struct vg3_ofunc_object *objp, struct vg3_ofunc_object *oparent)
{
  struct g_main *gmain = vmain;
  struct g_obj_player *gobj_player;

  if (gmain == NULL || objp == NULL || oparent == NULL) { return; }

  /* valid only when objp is playershot and oparent is player */
  if (strcmp(objp->oid, get_oid_name(OID_NAME_PLAYERSHOT)) != 0) { return; }
  if (strcmp(oparent->oid, get_oid_name(OID_NAME_PLAYER)) != 0) { return; }

  /* clear players's running shot */
  gobj_player = (struct g_obj_player *)oparent->ostruct;
  if (objp->subid == PLAYERSHOT_TORPEDO) {
    gobj_player->torpedo_running--;
  } else {
    gobj_player->shot_running--;
  }
}
