#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-player.h"
#include "obj-tanker.h"

void getoofc_player_tanker(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_player_tanker(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_PLAYER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_TANKER));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_player *gobj_player;
  struct g_obj_tanker *gobj_tanker;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private struct of OID_NAME_PLAYER and OID_NAME_TANKER */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_PLAYER)) == 0) {
    gobj_player = (struct g_obj_player *)objp1->ostruct;
    gobj_tanker = (struct g_obj_tanker *)objp2->ostruct;
  } else {
    gobj_player = (struct g_obj_player *)objp2->ostruct;
    gobj_tanker = (struct g_obj_tanker *)objp1->ostruct;
  }

  /* both explode */
  gobj_player->health = 0;
  gobj_tanker->health = 0;

  return VGAG3_COLL_RETURN_HIT;
}
