#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>

extern void init_dest_fighter(int);
extern void init_dest_factory(int);
extern void init_dest_mothership(int);
extern void init_dest_battleship(int);
extern void getofc_cargoship(struct vg3_ofunc_objfunc *);
extern void getofc_fighter(struct vg3_ofunc_objfunc *);
extern void getofc_playershot(struct vg3_ofunc_objfunc *);
extern void getofc_tanker(struct vg3_ofunc_objfunc *);
extern void getofc_escort(struct vg3_ofunc_objfunc *);
extern void getofc_factory(struct vg3_ofunc_objfunc *);
extern void getofc_mine(struct vg3_ofunc_objfunc *);
extern void getofc_bg(struct vg3_ofunc_objfunc *);
extern void getofc_player(struct vg3_ofunc_objfunc *);
extern void getofc_text(struct vg3_ofunc_objfunc *);
extern void getofc_bomber(struct vg3_ofunc_objfunc *);
extern void getofc_fightershot(struct vg3_ofunc_objfunc *);
extern void getofc_asteroid(struct vg3_ofunc_objfunc *);
extern void getofc_mothership(struct vg3_ofunc_objfunc *);
extern void getofc_battleship(struct vg3_ofunc_objfunc *);
extern void getofc_mothershot(struct vg3_ofunc_objfunc *);
extern void getofc_radar(struct vg3_ofunc_objfunc *);
extern void getoofc_factory_fightershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_bomber(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_factory(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_mine(struct vg3_ofunc_objobjfunc *);
extern void getoofc_escort_fighter(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_fightershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_asteroid_asteroid(struct vg3_ofunc_objobjfunc *);
extern void getoofc_battleship_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_asteroid(struct vg3_ofunc_objobjfunc *);
extern void getoofc_bomber_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_mothership(struct vg3_ofunc_objobjfunc *);
extern void getoofc_mothership_mothershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_cargoship(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_radar(struct vg3_ofunc_objobjfunc *);
extern void getoofc_battleship_fightershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_factory_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_mine_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_battleship(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_mothershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_tanker(struct vg3_ofunc_objobjfunc *);
extern void getoofc_cargoship_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_mothership_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_radar_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_asteroid_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_fighter_fightershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_fighter(struct vg3_ofunc_objobjfunc *);
extern void getoofc_player_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_fighter_asteroid(struct vg3_ofunc_objobjfunc *);
extern void getoofc_fighter_playershot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_tanker_playershot(struct vg3_ofunc_objobjfunc *);
extern void getofmgmt_factory(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_mine(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_radar(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_bomber(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_battleship(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_cargoship(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_tanker(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_asteroid(struct vg3_ofunc_ofmgmt *);
extern void getofmgmt_fighter(struct vg3_ofunc_ofmgmt *);

/* create new main-struct for object-functions */
struct vg3_ofunc * ofunc_new(void) {
  struct vg3_ofunc *ofstruct;
  struct vg3_ofunc_objinitdest oinitdest;
  struct vg3_ofunc_objvar ovar;
  struct vg3_ofunc_objfunc ofc;
  struct vg3_ofunc_objobjfunc oofc;
  struct vg3_ofunc_ofmgmt ofm;
  struct vg3_ofunc_ovkey ovkey;
  struct vg3_ofunc_okey okey;
  struct vg3_ofunc_ookey ookey;
  struct vg3_hash *h_initdest, *h_ovar, *h_okey, *h_ookey, *h_mgmt_okey, *h_seed, *h_mgmt_seed;

  ofstruct = calloc(1, sizeof(*ofstruct));
  if (ofstruct == NULL) { return NULL; }

  ofstruct->hget = VG3_hash_new();
  ofstruct->hobj = VG3_hash_new();
  ofstruct->hiid = VG3_hash_new();
  ofstruct->hmgmt = VG3_hash_new();

  h_initdest = VG3_hash_new();
  h_ovar = VG3_hash_new();
  h_okey = VG3_hash_new();
  h_ookey = VG3_hash_new();
  h_mgmt_okey = VG3_hash_new();
  h_seed = VG3_hash_new();
  h_mgmt_seed = VG3_hash_new();
  VG3_hash_set(ofstruct->hget, HGETSUB_INITDEST, sizeof(HGETSUB_INITDEST), &h_initdest, sizeof(h_initdest));
  VG3_hash_set(ofstruct->hget, HGETSUB_OVAR, sizeof(HGETSUB_OVAR), &h_ovar, sizeof(h_ovar));
  VG3_hash_set(ofstruct->hget, HGETSUB_OKEY, sizeof(HGETSUB_OKEY), &h_okey, sizeof(h_okey));
  VG3_hash_set(ofstruct->hget, HGETSUB_OOKEY, sizeof(HGETSUB_OOKEY), &h_ookey, sizeof(h_ookey));
  VG3_hash_set(ofstruct->hget, HGETSUB_SEED, sizeof(HGETSUB_SEED), &h_seed, sizeof(h_seed));
  VG3_hash_set(ofstruct->hmgmt, HMGMTSUB_OKEY, sizeof(HMGMTSUB_OKEY), &h_mgmt_okey, sizeof(h_mgmt_okey));
  VG3_hash_set(ofstruct->hmgmt, HMGMTSUB_SEED, sizeof(HMGMTSUB_SEED), &h_mgmt_seed, sizeof(h_mgmt_seed));

  (void)oinitdest;
  (void)ovar;
  (void)ofc;
  (void)oofc;
  (void)ofm;
  (void)ovkey;
  (void)okey;
  (void)ookey;

  memset(&oinitdest, 0, sizeof(oinitdest));
  init_dest_fighter(1);
  oinitdest.fkt = init_dest_fighter;
  VG3_hash_set(h_initdest, "1", sizeof("1"), &oinitdest, sizeof(oinitdest));

  memset(&oinitdest, 0, sizeof(oinitdest));
  init_dest_factory(1);
  oinitdest.fkt = init_dest_factory;
  VG3_hash_set(h_initdest, "2", sizeof("2"), &oinitdest, sizeof(oinitdest));

  memset(&oinitdest, 0, sizeof(oinitdest));
  init_dest_mothership(1);
  oinitdest.fkt = init_dest_mothership;
  VG3_hash_set(h_initdest, "3", sizeof("3"), &oinitdest, sizeof(oinitdest));

  memset(&oinitdest, 0, sizeof(oinitdest));
  init_dest_battleship(1);
  oinitdest.fkt = init_dest_battleship;
  VG3_hash_set(h_initdest, "4", sizeof("4"), &oinitdest, sizeof(oinitdest));

  memset(&ofc, 0, sizeof(ofc));
  getofc_cargoship(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_fighter(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_playershot(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_tanker(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_escort(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_factory(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_mine(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_bg(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_player(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_text(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_bomber(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_fightershot(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_asteroid(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_mothership(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_battleship(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_mothershot(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_radar(&ofc);
  if (*ofc.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
    VG3_hash_set(h_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_factory_fightershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_bomber(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_factory(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_mine(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_escort_fighter(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_fightershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_asteroid_asteroid(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_battleship_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_asteroid(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_bomber_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_mothership(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_mothership_mothershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_cargoship(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_radar(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_battleship_fightershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_factory_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_mine_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_battleship(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_mothershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_tanker(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_cargoship_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_mothership_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_radar_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_asteroid_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_fighter_fightershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_fighter(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_player_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_fighter_asteroid(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_fighter_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_tanker_playershot(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_factory(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_mine(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_radar(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_bomber(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_battleship(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_cargoship(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_tanker(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_asteroid(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_fighter(&ofm);
  if (*ofm.oid != '\0') {
    unsigned int *seed = calloc(1, sizeof(*seed));
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(h_mgmt_okey, &okey, sizeof(okey), &ofm, sizeof(ofm));
    VG3_hash_set(h_mgmt_seed, &okey, sizeof(okey), &seed, sizeof(seed));
  }

  VG3_ofunc_reset_seeds(ofstruct);

  return ofstruct;
}
