#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

struct random_check {
  unsigned int *seed;
  int is_permille;
  int rdno[1000];
  int rdpos;
};

struct random_check * random_check_new(unsigned int *, int);
void random_check_free(struct random_check *);
int random_check_exec(struct random_check *, int);


/* return initialized random-check-struct
 * @param seed         pointer to seed or NULL
 * @param is_permille  0 = accuracy is in percent,
 *                     1 = accuracy is in permille
 * @return             initialized random-check-struct
 *                     or NULL = error
 */
struct random_check *
random_check_new(unsigned int *seed, int is_permille)
{
  struct random_check *rdchk;
  int izahl, ipos1, ipos2, itmp;
  int maxzahl;

  rdchk = calloc(1, sizeof(*rdchk));
  if (rdchk == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }

  rdchk->seed = seed;

  rdchk->is_permille = !!is_permille;

  if (rdchk->is_permille) { maxzahl = 1000; } else { maxzahl = 100; }

  for (izahl = 0; izahl < maxzahl; izahl++) {
    rdchk->rdno[izahl] = izahl + 1;
  }

  for (izahl = 0; izahl < maxzahl; izahl++) {
    if (rdchk->seed == NULL) {
      ipos1 = (int)VG3_nw_get_random(1, maxzahl);
      ipos2 = (int)VG3_nw_get_random(1, maxzahl);
    } else {
      ipos1 = (int)VG3_nw_random_getnext(1, maxzahl, rdchk->seed);
      ipos2 = (int)VG3_nw_random_getnext(1, maxzahl, rdchk->seed);
    }
    itmp = rdchk->rdno[ipos1 - 1];
    rdchk->rdno[ipos1 - 1] = rdchk->rdno[ipos2 - 1];
    rdchk->rdno[ipos2 - 1] = itmp;
  }
  rdchk->rdpos = 0;

  return rdchk;
}


/* destroy random-check-struct
 * @param rdchk  random-check-struct
 */
void
random_check_free(struct random_check *rdchk)
{
  if (rdchk == NULL) { return; }
  free(rdchk);
}


/* execute random-check
 * @param rdchk     random-check-struct
 * @param permille  possibility to get a hit, always in permille
 * @return          0            = no hit
 *                  1 - permille = hit: at which position found
 */
int
random_check_exec(struct random_check *rdchk, int permille)
{
  int searchno, rdpos;
  int maxzahl, permidx;

  if (rdchk == NULL) { return 0; }
  if (permille <= 0) { return 0; }
  if (permille > 1000) { permille = 1000; }

  if (rdchk->is_permille) { maxzahl = 1000; } else { maxzahl = 100; permille /= 10; }

  if (rdchk->seed == NULL) {
    searchno = (int)VG3_nw_get_random(1, maxzahl);
  } else {
    searchno = (int)VG3_nw_random_getnext(1, maxzahl, rdchk->seed);
  }

  rdpos = rdchk->rdpos;
  for (permidx = 1; permidx <= permille; permidx++) {
    if (++rdchk->rdpos >= maxzahl) { rdchk->rdpos = 0; }
    if (rdchk->rdno[rdchk->rdpos] == searchno) { break; }
  }

  if (rdpos != rdchk->rdpos && permidx <= permille) {
    if (!rdchk->is_permille) { permidx *= 10; }
    return permidx;
  }
  return 0;
}
