/* Example for animation functions */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames3.h>

int main(int argc, char **argv) {
  /* Create an animated sprite with an image "sunnyboy.bmp"
   * which rotates this image twice around
   * and show it until the sprite ends
   */

  struct vg3_window *wstruct;
  int winw, winh;

  /* open window */
  wstruct = VG3_window_new(argv[0], VGAG3_VGAVERSION_LOW, VGAG3_WINSCALE_BESTSCALE);
  if (wstruct == NULL) { fprintf(stderr, "%s\n", VG3_error()); exit(1); }

  /* get the size of the window */
  VG3_window_getsize(wstruct, &winw, &winh);

  /* create a sunnyboy sprite,
   * which rotates a sunnyboy image two times,
   * and show it
   */
  { struct vg3_sprite *sprt;
    int lifetime;
    int dfl_loop;
    int repeat;
    struct vg3_image_attributes imgattr;
    struct vg3_image *imgptr;

    /* create an empty animated sprite */
    sprt = VG3_sprite_new(wstruct);
    if (sprt == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto byebye; }

    /* set default values:
     * repeat sprite two times
     * one game loop for each sprite element
     */
    lifetime = 2;
    dfl_loop = 1;
    VG3_sprite_setattr(sprt, &lifetime, &dfl_loop, NULL);

    /* add 360 sprite elements,
     * each showing the sunnyboy image rotated according to value of repeat
     */
    for (repeat = 1; repeat <= 360; repeat++) {
      VGAG3_IMAGE_ATTRIBUTES_DEFAULT(&imgattr);
      imgattr.rotate = repeat;
      VG3_sprite_addelem(sprt, 0, "sunnyboy.bmp", &imgattr, NULL, 0);
    }

    /* game loop */
    VG3_discard_input(wstruct);
    for (;;) {
      /* clear window */
      VG3_draw_clear(wstruct, NULL, VGAG3_COLOR_BLACK);

      /* get next sprite element,
       * if sprite ended, exit game loop
       */
      if (!VG3_sprite_get(sprt, &imgptr, &imgattr, NULL)) { break; }

      /* draw image, if not NULL, onto the middle of the window */
      if (imgptr != NULL) {
        VG3_image_copy(wstruct, NULL, imgptr, winw / 2, winh / 2, &imgattr, 0);
      }

      /* update window and get key-strokes */
      VG3_window_update(wstruct, 0, 0);
      if (VG3_inputevent_update(wstruct) > 0) { break; }

      /* quit? */
      if (VG3_key_ispressed(wstruct, VGAG3_KEY_SPACE, VGAG3_IS_NEW_PRESSED)) { break; }
      if (VG3_key_ispressed(wstruct, VGAG3_KEY_ENTER, VGAG3_IS_NEW_PRESSED)) { break; }

      /* wait up to 10 msec */
      VG3_wait_time(10);
    }
    VG3_discard_input(wstruct);

    /* free the sprite */
    VG3_sprite_free(sprt);
  }

  /* if an error occurred after creating the window, close it before exiting */
  byebye:
  /* close window */
  VG3_window_free(wstruct);

  exit(0);
}
