#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

extern struct vg3_ofunc * ofunc_new(void);

const char * get_oid_name(int);


/* get_oid_name:
 * returns object-ID as a string
 * @param oidn  object-ID (OID_NAMES)
 * @return      object-ID as string (or empty)
 */
const char *
get_oid_name(int oidn)
{
  switch(oidn) {
    case OID_NAME_DICE:      return "dice";
    case OID_NAME_SELECT:    return "select";
    case OID_NAME_SUNNYBOY:  return "sunnyboy";
  }
  return "";
}


int main(int argc, char **argv) {
  struct g_main gmain;
  const struct vg3_ofunc_objfunc *ofc;

  memset(&gmain, 0, sizeof(gmain));

  /* open window */
  gmain.wstruct = VG3_window_new(argv[0], VGAG3_VGAVERSION_LOW, VGAG3_WINSCALE_BESTSCALE);
  if (gmain.wstruct == NULL) { fprintf(stderr, "%s\n", VG3_error()); exit(1); }

  /* get the size of the window */
  VG3_window_getsize(gmain.wstruct, &gmain.winw, &gmain.winh);

  /* create main-struct for object-functions */
  gmain.ofstruct = ofunc_new();

  /* create object-instances */

  /* dice */
  ofc = VG3_ofunc_get_objfunc(gmain.ofstruct, get_oid_name(OID_NAME_DICE));
  if (ofc == NULL) {
    fprintf(stderr, "Object \"%s\" not found\n", get_oid_name(OID_NAME_DICE));
    goto endgame;
  }
  if (ofc->f_new(&gmain, 0) == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto endgame; }

  /* two select-instances with both sub-IDs */
  ofc = VG3_ofunc_get_objfunc(gmain.ofstruct, get_oid_name(OID_NAME_SELECT));
  if (ofc == NULL) {
    fprintf(stderr, "Object \"%s\" not found\n", get_oid_name(OID_NAME_SELECT));
    goto endgame;
  }
  if (ofc->f_new(&gmain, 0, ASTACK_SELECT_SUNNYBOY) == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto endgame; }
  if (ofc->f_new(&gmain, 0, ASTACK_SELECT_DIRECTION) == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto endgame; }

  /* two sunnyboy-instances */
  ofc = VG3_ofunc_get_objfunc(gmain.ofstruct, get_oid_name(OID_NAME_SUNNYBOY));
  if (ofc == NULL) {
    fprintf(stderr, "Object \"%s\" not found\n", get_oid_name(OID_NAME_SUNNYBOY));
    goto endgame;
  }
  if (ofc->f_new(&gmain, 0, 1) == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto endgame; }
  if (ofc->f_new(&gmain, 0, 2) == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto endgame; }

  /* create actionstack and insert action ASTACK_DICE */
  gmain.astck = VG3_actionstack_new();
  VG3_actionstack_push(gmain.astck, ASTACK_DICE, NULL, 0);

  /* game-loop */
  VG3_discard_input(gmain.wstruct);
  for (;;) {
    if (gmain.exit) { break; }
    if (VG3_inputevent_update(gmain.wstruct)) { break; }

    /* Q: exit */
    if (VG3_key_ispressed(gmain.wstruct, VGAG3_KEY_Q, VGAG3_IS_NEW_PRESSED)) { break; }

    VG3_draw_clear(gmain.wstruct, NULL, VGAG3_COLOR_BLACK);

    /* call object-functions */
    VG3_ofunc_objlist_call_run(gmain.ofstruct, &gmain);
    VG3_ofunc_objlist_call_draw(gmain.ofstruct, &gmain);

    VG3_window_update(gmain.wstruct, 0, 0);

    VG3_wait_time(80);
  }
  VG3_discard_input(gmain.wstruct);

  /* clean up */
  if (gmain.ofstruct != NULL) {
    VG3_ofunc_objlist_call_free(gmain.ofstruct, &gmain, NULL);
    VG3_ofunc_free(gmain.ofstruct);
  }
  VG3_actionstack_free(gmain.astck);

endgame:
  /* close window and exit */
  VG3_window_free(gmain.wstruct);
  exit(0);
}
