#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames3.h>

/* object-ID enumeration */
typedef enum {
  OID_NAME_DICE,
  OID_NAME_SELECT,
  OID_NAME_SUNNYBOY
} OID_NAMES;

/* actions of actionstack */
enum {
  ASTACK_DICE = 1,  /* throw (text-)dice
                     * parameters: no
                     */
  ASTACK_SELECT,    /* select by key-stroke
                     * according to sub-ID of object-instance:
                     *  - sub-ID = ASTACK_SELECT_SUNNYBOY: select sunnyboy
                     *  - sub-ID = ASTACK_SELECT_DIRECTION: select moving direction
                     * parameters:
                     * - steps: (for ASTACK_SELECT_SUNNYBOY:) number of moving-steps
                     * - select: sub-ID
                     */
  ASTACK_SUNNYBOY   /* move sunnyboy
                     * parameters:
                     * - steps: number of moving-steps
                     * - number: selected sunnyboy
                     * - direction: moving-direction
                     */
};

/* sub-IDs for the object OID_NAME_SELECT */
enum {
  ASTACK_SELECT_SUNNYBOY = 1,
  ASTACK_SELECT_DIRECTION
};

/* main game struct */
struct g_main {
  struct vg3_window *wstruct;     /* window struct */
  int winw, winh;                 /* window size: width and height */
  int exit;                       /* exit, if set to 1 */
  struct vg3_ofunc *ofstruct;     /* object function main struct */
  struct vg3_actionstack *astck;  /* stack of actions */
};


extern const char * get_oid_name(int);

#endif /* MAIN_H_ */
