/* Example for event functions */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames3.h>

int main(int argc, char **argv) {
  /* print infos of gamecontrollers and joysticks
   * print exclusively pressed keyboard-keys, until return-key is pressed
   */

  struct vg3_window *wstruct;

  /* open window */
  wstruct = VG3_window_new(argv[0], VGAG3_VGAVERSION_LOW, VGAG3_WINSCALE_NOSCALE);
  if (wstruct == NULL) { fprintf(stderr, "%s\n", VG3_error()); exit(1); }

  /* print infos of all found gamecontrollers and joysticks */
  { int *rjid, idx, jid;
    struct vg3_gamecontroller gcs;

    VG3_gamecontroller_getall(wstruct, &rjid);
    for (idx = 1; idx <= rjid[0]; idx++) {  /* for each device */
      jid = rjid[idx];
      VG3_gamecontroller_getinfo(wstruct, jid, &gcs);
      if (gcs.is_gamecontroller) {
        printf("Gamecontroller %d [joystick-ID=%d]: \"%s\"\n", idx, gcs.jid, gcs.name);
      } else {
        printf("Joystick %d [joystick-ID=%d], buttons/axes=%d: \"%s\"\n", idx, gcs.jid, gcs.joy_num_input, gcs.name);
      }
    }

    /* free array */
    free(rjid);
  }

  /* print exclusively pressed keyboard-keys, until return-key is pressed */
  printf("\nPress keys, quit with return-key\n");
  { int kbidx;

    /* throw away pending events */
    VG3_discard_input(wstruct);

    /* game loop */
    for (;;) {
      /* retrieve new events, exit if got request for closing the window */
      if (VG3_inputevent_update(wstruct) > 0) { break; }

      /* check if return-key is pressed for exiting */
      if (VG3_key_ispressed(wstruct, VGAG3_KEY_ENTER, VGAG3_IS_NEW_PRESSED)) { break; }

      /* print out exclusively pressed keys */
      kbidx = VG3_key_getpressed(wstruct);
      if (kbidx != VGAG3_KEY_NOKEY) {
        printf("%s pressed\n", VG3_key_num2name(wstruct, kbidx));
      }

      /* wait up to 50 msec */
      VG3_wait_time(50);
    }

    /* again throw away pending events */
    VG3_discard_input(wstruct);
  }

  /* close window */
  VG3_window_free(wstruct);

  exit(0);
}
