/* gcc -W -Wall -O2 -g xx.c `vgagames3-config --cflags --libs` */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames3.h>

int main(int argc, char **argv) {
  struct vg3_multilang *mlang;
  const char *cptr;

  /* create multilanguage structure */
  mlang = VG3_multilang_new(NULL, "en");

  /* add entries from test1.mlang */
  if (!VG3_multilang_add(mlang, "test1.mlang")) { fprintf(stderr, "test1.mlang not found\n"); exit(1); }

  /* add entries from test2.mlang */
  if (!VG3_multilang_add(mlang, "test2.mlang")) { fprintf(stderr, "test2.mlang not found\n"); exit(1); }

  /* show entries of mlang1 */
  cptr = VG3_multilang_get(mlang, "test1-entry1");
  printf("entry1 of test1.mlang: %s\n", cptr);
  cptr = VG3_multilang_get(mlang, "test1-entry2");
  printf("entry2 of test1.mlang: %s\n", cptr);

  /* show entries of mlang2 */
  cptr = VG3_multilang_get(mlang, "test2-entry1");
  printf("entry1 of test2.mlang: %s\n", cptr);
  cptr = VG3_multilang_get(mlang, "test2-entry2");  /* does not exist, uses key */
  printf("entry2 of test2.mlang: %s\n", cptr);

  /* destroy multilanguage structure */
  VG3_multilang_free(mlang);

  exit(0);
}
