/* game */
#include "game.h"

extern struct vg3_ofunc * ofunc_new(void);

int
main(int argc, char **argv) {
  const int use_mgmt = 1;  /* if 1 use object-management for sunnyboy */
  struct game gstruct;

  /* open window */
  gstruct.wstruct = VG3_window_new(argv[0], VGAG3_VGAVERSION_LOW, VGAG3_WINSCALE_NOSCALE);
  if (gstruct.wstruct == NULL) { fprintf(stderr, "%s\n", VG3_error()); exit(1); }

  /* get window size */
  VG3_window_getsize(gstruct.wstruct, &gstruct.w, &gstruct.h);

  /* create the common VgaGames3-object structure */
  gstruct.ofstruct = ofunc_new();

  if (use_mgmt) {
    /* activate sunnyboy-object-management with 3 sunnyboy-instances */
    if (VG3_ofunc_mgmt_activate(gstruct.ofstruct, &gstruct, OID_SUNNYBOY, 3) != 0) {
      fprintf(stderr, "%s\n", VG3_error());
      goto endgame;
    }
  } else {
    /* create instance of sunnyboy object and put it to the left */
    const struct vg3_ofunc_objfunc *ofc;
    ofc = VG3_ofunc_get_objfunc(gstruct.ofstruct, OID_SUNNYBOY);
    if (ofc == NULL) { fprintf(stderr, "Need sunnyboy-object, but not found\n"); goto endgame; }
    if (ofc->f_new(&gstruct, 0, 0, gstruct.h / 2) == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto endgame; }
  }

  /* game loop */
  for (;;) {
    if (VG3_inputevent_update(gstruct.wstruct)) { break; }

    VG3_draw_clear(gstruct.wstruct, NULL, VGAG3_COLOR_BLACK);

    if (use_mgmt) {
      /* execute object-managing */
      VG3_ofunc_mgmt_run(gstruct.ofstruct, &gstruct);
    }

    /* execute run-function of loaded object-instances */
    VG3_ofunc_objlist_call_run(gstruct.ofstruct, &gstruct);

    /* execute draw-function of loaded object-instances */
    VG3_ofunc_objlist_call_draw(gstruct.ofstruct, &gstruct);

    VG3_window_update(gstruct.wstruct, 0, 0);

    VG3_wait_time(20);

    if (use_mgmt) {
      /* if there is no remaing sunnyboy, quit */
      if (VG3_ofunc_mgmt_data(gstruct.ofstruct, &gstruct, OID_SUNNYBOY, NULL) == 0) { break; }
    } else {
      /* if sunnyboy has gone, quit game */
      if (VG3_ofunc_objlist_find_obj(gstruct.ofstruct, OID_SUNNYBOY, NULL) < 1) { break; }
    }
  }

  /* unload and free still existing object-instances */
  VG3_ofunc_objlist_call_free(gstruct.ofstruct, &gstruct, NULL);

  if (use_mgmt) {
    /* deactivate still existing object-managements */
    VG3_ofunc_mgmt_deactivate(gstruct.ofstruct, &gstruct, NULL);
  }

  /* free common VgaGames3-object structure */
  VG3_ofunc_free(gstruct.ofstruct);

endgame:
  /* close window */
  VG3_window_free(gstruct.wstruct);

  exit(0);
}
