/* sunnyboy object */
#include "game.h"
#include "sunnyboy.h"

static struct vg3_ofunc_object * f_new(void *, unsigned int, ...);
static void f_free(void *, struct vg3_ofunc_object *);
static void f_run(void *, struct vg3_ofunc_object *);
static void f_draw(void *, struct vg3_ofunc_object *);

/* fill out the passed structure for object-functions of this VgaGames3-object */
void
getofc_sboy(struct vg3_ofunc_objfunc *ofc) {
  if (ofc == NULL) { return; }
  snprintf(ofc->oid, sizeof(ofc->oid), "%s", OID_SUNNYBOY);
  ofc->f_new = f_new;
  ofc->f_free = f_free;
  ofc->f_run = f_run;
  ofc->f_draw = f_draw;
  /* we don't need f_data */
}

/* now define the functions */

/* create a new object-instance */
static struct vg3_ofunc_object *
f_new(void *vgame, unsigned int parent_objid, ...) {
  /* vgame: individual game structure, here: struct game *
   * parent_objid: we don't need it here either
   */
  struct game *gstruct = (struct game *)vgame;
  struct vg3_ofunc_object *objp;
  struct sboy *gobj;
  va_list ap;

  objp = calloc(1, sizeof(*objp));  /* create VgaGames3-object structure for this instance */
  gobj = calloc(1, sizeof(*gobj));  /* create private structure for this instance */

  /* set private structure */
  /* as variadic parameter we got the position xm and ym */
  va_start(ap, parent_objid);
  gobj->xm = va_arg(ap, int);
  gobj->ym = va_arg(ap, int);
  va_end(ap);
  /* load image */
  gobj->img = VG3_image_load(gstruct->wstruct, "sunnyboy.bmp", 0);

  /* set VgaGames3-object structure */
  snprintf(objp->oid, sizeof(objp->oid), "%s", OID_SUNNYBOY);
  objp->drawlevel = 1;
  objp->instanceid = 0;  /* will be set in VG3_ofunc_objlist_insert() */
  objp->ostruct = gobj;  /* set private structure into VgaGames3-object structure */

  /* insert instance into list of object-instances */
  VG3_ofunc_objlist_insert(gstruct->ofstruct, objp);

  return objp;
}

/* free an object-instance */
static void
f_free(void *vgame, struct vg3_ofunc_object *objp) {
  struct game *gstruct = (struct game *)vgame;
  struct sboy *gobj;

  gobj = (struct sboy *)objp->ostruct;

  /* remove instance from list of object-instances */
  VG3_ofunc_objlist_remove(gstruct->ofstruct, objp);

  /* free instance */
  VG3_image_unload(gstruct->wstruct, gobj->img);
  free(gobj);
  free(objp);
}

/* move an object-instance */
static void
f_run(void *vgame, struct vg3_ofunc_object *objp) {
  struct game *gstruct = (struct game *)vgame;
  struct sboy *gobj;

  gobj = (struct sboy *)objp->ostruct;

  /* very simple: just move to the right,
   * normally we would check keystrokes
   * or move it according to an algorithm
   */
  gobj->xm++;

  /* remove sunnyboy if it has reached the right border */
  if (gobj->xm > gstruct->w) { f_free(vgame, objp); }
}

/* draw an object-instance */
static void
f_draw(void *vgame, struct vg3_ofunc_object *objp) {
  struct game *gstruct = (struct game *)vgame;
  struct sboy *gobj;

  gobj = (struct sboy *)objp->ostruct;

  VG3_image_copy(gstruct->wstruct, NULL, gobj->img, gobj->xm, gobj->ym, NULL, 0);
}
