/* sunnyboy object-management */

#include "game.h"

/* static structure for this object-managing */
static struct {
  int remaining;  /* how many sunnyboys to show */
} sunnyboy_mgmt;

static int f_activate(void *, struct vg3_ofunc *, va_list);
static void f_deactivate(void *, struct vg3_ofunc *);
static void f_run(void *, struct vg3_ofunc *);
static int f_data(void *, struct vg3_ofunc *, void *);


/* fill out the passed structure for object-management-functions of this VgaGames3-object */
void
getofmgmt_sboy(struct vg3_ofunc_ofmgmt *ofm) {
  if (ofm == NULL) { return; }
  snprintf(ofm->oid, sizeof(ofm->oid), "%s", OID_SUNNYBOY);
  ofm->f_activate = f_activate;
  ofm->f_deactivate = f_deactivate;
  ofm->f_run = f_run;
  ofm->f_data = f_data;
}

/* now define the functions */

/* activate the managing of sunnyboys, pass number of them to show */
static int
f_activate(void *vgame, struct vg3_ofunc *ofstruct, va_list ap)
{
  /* vgame: individual game structure, here: struct game, but we don't need it */
  struct game *gstruct = (struct game *)vgame;
  (void)gstruct;

  if (ofstruct == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }

  /* as variadic parameter we got the number of sunnyboys,
   * we put it into our static structure
   */
  sunnyboy_mgmt.remaining = va_arg(ap, int);

  return 0;
}

/* deactivate the managing of sunnyboys */
static void
f_deactivate(void *vgame, struct vg3_ofunc *ofstruct)
{
  /* vgame: individual game structure, here: struct game, but we don't need it */
  struct game *gstruct = (struct game *)vgame;
  (void)gstruct;

  if (ofstruct == NULL) { return; }

  /* now we clean up our static structure */
  sunnyboy_mgmt.remaining = 0;
}

/* execute managing of sunnyboy-instances,
 * creating a new one, if no sunnyboy is active
 */
static void
f_run(void *vgame, struct vg3_ofunc *ofstruct)
{
  /* vgame: individual game structure, here: struct game */
  struct game *gstruct = (struct game *)vgame;

  if (ofstruct == NULL) { return; }

  /* we check whether a sunnyboy is still active,
   * if not, we create a new one,
   * until sunnyboy_mgmt.remaining is decremented to 0
   */
  if (VG3_ofunc_objlist_find_obj(ofstruct, OID_SUNNYBOY, NULL) == 0) {
    if (sunnyboy_mgmt.remaining > 0) {
      const struct vg3_ofunc_objfunc *ofc;
      ofc = VG3_ofunc_get_objfunc(ofstruct, OID_SUNNYBOY);
      if (ofc == NULL) { sunnyboy_mgmt.remaining = 0; return; }
      if (ofc->f_new(vgame, 0, 0, gstruct->h / 2) == NULL) {  /* create sunnyboy-instance */
        fprintf(stderr, "%s\n", VG3_error());
        sunnyboy_mgmt.remaining = 0;
        return;
      }
      sunnyboy_mgmt.remaining--;
      printf("New sunnyboy-instance created, remaining: %d\n", sunnyboy_mgmt.remaining);
    }
  }
}

/* return number of remaining sunnyboys including the active one */
static int
f_data(void *vgame, struct vg3_ofunc *ofstruct, void *vdata)
{
  int retw;
  /* vgame: individual game structure, here: struct game, but we don't need it */
  struct game *gstruct = (struct game *)vgame;
  (void)gstruct;

  /* we don't need vdata either */
  (void)vdata;

  if (ofstruct == NULL) { return 0; }

  /* add to the number of remaining sunnyboys the active one, if existing */
  retw = VG3_ofunc_objlist_find_obj(ofstruct, OID_SUNNYBOY, NULL);
  retw += sunnyboy_mgmt.remaining;

  return retw;
}
