/* Example for video functions */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <vgagames3.h>

int main(int argc, char **argv) {
  /* create an image with a text
   * draw this image onto the window waiting for pressing space-key
   */

  struct vg3_window *wstruct;
  int winw, winh;

  /* open window */
  wstruct = VG3_window_new(argv[0], VGAG3_VGAVERSION_LOW, VGAG3_WINSCALE_BESTSCALE);
  if (wstruct == NULL) { fprintf(stderr, "%s\n", VG3_error()); exit(1); }

  /* get the size of the window */
  VG3_window_getsize(wstruct, &winw, &winh);

  /* draw text to an image and copy it onto the window */
  { const int do_i_want_a_corrected_rectangle = 0;  /* set this to 0 or 1 */
    struct vg3_image *imgptr;
    struct vg3_text stxt;
    struct vg3_rect rect;
    int imgw, imgh;

    /* +++ create an image and print a text to it +++ */

    /* create an empty image with width+height 150x80 pixels */
    imgw = 150;
    imgh = 80;
    imgptr = VG3_image_create(wstruct, imgw, imgh);
    if (imgptr == NULL) { fprintf(stderr, "%s\n", VG3_error()); goto byebye; }

    /* draw a rectangle to the borders of the image */
    rect.x = 0;
    rect.w = imgw;
    rect.y = 0;
    rect.h = imgh;
    VG3_draw_rect(wstruct, imgptr, &rect, 0, VGAG3_COLOR_RED);

    /* prepare the text structure,
     * we want to display "Press space to exit"
     * with the shipped fontfile "10x17.font"
     */
    VGAG3_TEXT_ATTRIBUTES_SET(&stxt, "10x17.font", '\n', 0, "Press space to exit");

    /* set the destination rectangle,
     * we want to have a border of minimal 10 pixels on each side
     */
    rect.x = 10;
    rect.w = imgw - 20;
    rect.y = 10;
    rect.h = imgh - 20;

    /* now we could do a dry-run drawing to get the corrected destination rectangle */
    if (do_i_want_a_corrected_rectangle) {
      rect = VG3_draw_text(wstruct, imgptr, &rect, ' ', &stxt, VGAG3_COLOR_RED, VGAG3_COLOR_BLUE, 1);
    }

    /* draw the text to the image */
    VG3_draw_text(wstruct, imgptr, &rect, ' ', &stxt, VGAG3_COLOR_RED, VGAG3_COLOR_BLUE, 0);


    /* +++ copy the image onto the window and wait for pressing space-key +++ */

    /* copy the image right aligned and vertically centered to the window */
    VG3_image_copy(wstruct, NULL, imgptr, winw - (imgw / 2), winh / 2, NULL, 0);

    /* update window contents and wait for pressing space-key */
    VG3_discard_input(wstruct);
    for (;;) {
      if (VG3_inputevent_update(wstruct) > 0) { break; }
      if (VG3_key_ispressed(wstruct, VGAG3_KEY_SPACE, VGAG3_IS_NEW_PRESSED)) { break; }
      VG3_window_update(wstruct, 0, 0);
      VG3_wait_time(50);
    }
    VG3_discard_input(wstruct);

    /* free the image */
    VG3_image_unload(wstruct, imgptr);
  }

  /* if an error occurred after creating the window, close it before exiting */
  byebye:
  /* close window */
  VG3_window_free(wstruct);

  exit(0);
}
